/*
 * File:		m4_cache.c
 * Purpose:		useful functions for the cache
 *
 */

#include "MAC57D54H.h"
#include "m4_cache.h"

/* To Initialize both caches, make these two function calls
 *  m4_cache_init(CODE_CACHE);
 *  m4_cache_init(SYS_CACHE);
 */

uint8_t m4_cache_init(uint8_t cache)
{

  if (cache == CODE_CACHE)
  {

      /* Code Cache Init */

      /* Cache Set Command: set command bits in CCR */
      /* set invalidate way 1 and invalidate way 0 bits */
      LMEM.PCCCR.R = 0x05000000;

      /* set ccr[go] bit to initiate command to invalidate cache */
      LMEM.PCCCR.B.GO = 0x1;

      /* wait until the ccr[go] bit clears to indicate command complete */
      while(LMEM.PCCCR.B.GO==0x1);
	  
      /* enable write buffer */
      LMEM.PCCCR.B.ENWRBUF = 0x1;

      /* enable cache */
      LMEM.PCCCR.B.ENCACHE = 0x1;

  }else if (cache == SYS_CACHE)
  {

      /* System Cache Init */

      /* Cache Set Command: set command bits in CCR */
      /* set invalidate way 1 and invalidate way 0 bits */
      LMEM.PSCCR.R = 0x05000000;

      /* set ccr[go] bit to initiate command to invalidate cache */
      LMEM.PSCCR.B.GO = 0x1;

      /* wait until the ccr[go] bit clears to indicate command complete */
      while(LMEM.PSCCR.B.GO==0x1);

      /* enable write buffer */
      LMEM.PSCCR.B.ENWRBUF = 0x1;

      /* enable cache */
      LMEM.PSCCR.B.ENCACHE = 0x1;

  } else
  {
     return CACHE_INVALID_PARAM;
  }

  return CACHE_OK;

}


uint8_t m4_cache_disable(uint8_t cache)
{

  if (cache == CODE_CACHE)
  {
       /* Disable code cache */
       LMEM.PCCCR.R = 0;

  }else if (cache == SYS_CACHE)
  {
       /* Disable system cache */
       LMEM.PSCCR.R = 0;

  } else
  {
     return CACHE_INVALID_PARAM;
  }

  return CACHE_OK;

}


uint8_t m4_cache_invalidate(uint8_t cache)
{

  if (cache == CODE_CACHE)
  {
      /* Cache Set Command: set command bits in CCR */
      /* set invalidate way 1 and invalidate way 0 bits */
      LMEM.PCCCR.R = 0x05000000; /* set INVW0 and INVW1 */

      /* set ccr[go] bit to initiate command to invalidate cache */
      LMEM.PCCCR.B.GO = 0x1;

      /* wait until the ccr[go] bit clears to indicate command complete */
      while(LMEM.PCCCR.B.GO==0x1);

  }else if (cache == SYS_CACHE)
  {
      /* Cache Set Command: set command bits in CCR */
      /* set invalidate way 1 and invalidate way 0 bits */
      LMEM.PSCCR.R = 0x05000000; /* set INVW0 and INVW1 */

      /* set ccr[go] bit to initiate command to invalidate cache */
      LMEM.PSCCR.B.GO = 0x1;

      /* wait until the ccr[go] bit clears to indicate command complete */
      while(LMEM.PSCCR.B.GO==0x1);

  } else
  {
     return CACHE_INVALID_PARAM;
  }

  return CACHE_OK;

}

